/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.data.impl;

import ec.gob.sri.anexo.catalogo.api.carga.AdministradorCatalogos;
import ec.gob.sri.anexo.catalogo.api.enums.FuenteEnum;
import ec.gob.sri.anexo.catalogo.api.excepciones.InstaciacionExcepcion;
import ec.gob.sri.anexo.catalogo.carga.impl.AdministradorCargaCatalogosImpl;
import ec.gob.sri.anexo.catalogo.carga.impl.AdministradorCargaFiguraJuridicaImpl;
import ec.gob.sri.anexo.catalogo.carga.impl.AdministradorCargaPaisesImpl;
import ec.gob.sri.anexo.catalogo.carga.impl.AdministradorCargaPaisesSinParaisosImpl;
import ec.gob.sri.anexo.catalogo.carga.impl.AdministradorCargaParaisoFiscalImpl;
import ec.gob.sri.anexo.catalogo.carga.impl.AdministradorCargaRetencionDividendosImpl;
import ec.gob.sri.anexo.catalogo.carga.impl.AdministradorCargaUbicacionesImpl;
import ec.gob.sri.anexo.catalogo.modelo.AdmPais;
import ec.gob.sri.anexo.catalogo.modelo.AdmUbicacionesGeograficas;
import ec.gob.sri.anexo.catalogo.modelo.ItemRetencionDividendos;
import ec.gob.sri.anexo.catalogo.modelo.PaisSinParaiso;
import ec.gob.sri.anexo.catalogo.modelo.ParaisoFiscal;
import ec.gob.sri.anexo.catalogo.modelo.RigDetalleCatalogo;
import ec.gob.sri.anexo.catalogo.modelo.RigFiguraJuridica;
import ec.gob.sri.dimm.api.logger.PluginLogger;
import ec.gob.sri.dimm.data.impl.ConexionBD;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.joda.time.LocalDate;

public class DataCatalogos {
    protected static AdministradorCatalogos ac = null;
    private static AdministradorCargaUbicacionesImpl acu = null;
    private static AdministradorCargaPaisesImpl acp = null;
    private static AdministradorCargaRetencionDividendosImpl acr = null;
    protected static AdministradorCargaParaisoFiscalImpl acParaisosFiscales = null;
    private static AdministradorCargaPaisesSinParaisosImpl acPaisesSinParaisos = null;
    private static AdministradorCargaFiguraJuridicaImpl acFiguraJuridica = null;
    public static final String FRACCION_BASICA = "fraccionBasica";
    public static final String EXCESO_HASTA = "excesoHasta";
    public static final String RETENCION_SOBRE_FRACCION = "retencionSobreFraccionBase";
    public static final String PORCENTAJE_DE_RETENCION = "porcentajeRetencion";
    private static final Object bloqueoInstancia = new Object();
    private static DataCatalogos instancia = null;

    static {
        ac = AdministradorCargaCatalogosImpl.getInstancia((FuenteEnum)FuenteEnum.DIMM);
        acu = AdministradorCargaUbicacionesImpl.getInstancia((FuenteEnum)FuenteEnum.DIMM);
        acp = AdministradorCargaPaisesImpl.getInstancia((FuenteEnum)FuenteEnum.DIMM);
        try {
            acr = AdministradorCargaRetencionDividendosImpl.getInstancia((FuenteEnum)FuenteEnum.DIMM);
            acParaisosFiscales = AdministradorCargaParaisoFiscalImpl.getInstancia((FuenteEnum)FuenteEnum.DIMM);
            acPaisesSinParaisos = AdministradorCargaPaisesSinParaisosImpl.getInstancia((FuenteEnum)FuenteEnum.DIMM);
            acFiguraJuridica = AdministradorCargaFiguraJuridicaImpl.getInstancia((FuenteEnum)FuenteEnum.DIMM);
        }
        catch (InstaciacionExcepcion e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataCatalogos crearInstancia() {
        Object object = bloqueoInstancia;
        synchronized (object) {
            if (instancia == null) {
                instancia = new DataCatalogos();
            }
        }
        return instancia;
    }

    public static void inicializarData() {
        block8: {
            Connection con = null;
            ConexionBD cbdd = new ConexionBD();
            con = cbdd.obtenerConexion();
            boolean estadoCatGener = false;
            boolean estadoUbicGeograf = false;
            boolean estadoPaises = false;
            boolean estadoRetencionDiv = false;
            boolean ban = false;
            boolean estadoParaisosFiscales = false;
            boolean estadoPaisesSinParaiso = false;
            boolean estadoFiguraJuridica = false;
            try {
                try {
                    estadoCatGener = ac.inicializarCatalogos(con, FuenteEnum.DIMM);
                    estadoUbicGeograf = acu.inicializarUbicaciones(con);
                    estadoPaises = acp.inicializarPaises(con);
                    estadoRetencionDiv = acr.inicializar(con);
                    estadoParaisosFiscales = acParaisosFiscales.inicializar(con);
                    estadoPaisesSinParaiso = acPaisesSinParaisos.inicializar(con);
                    estadoFiguraJuridica = acFiguraJuridica.inicializarFiguraJuridica(con);
                }
                catch (Exception e) {
                    ban = true;
                    PluginLogger.logError((String)String.format("Carga de catalogos erronea. EstadoCatGener: %s, EstadoUbicGeograf: %s, EstadoPaises: %s, EstadoParaisosFiscales: %s, EstadoPaisesSinParaiso: %s", estadoCatGener, estadoUbicGeograf, estadoPaises, estadoParaisosFiscales, estadoPaisesSinParaiso, estadoFiguraJuridica), (String)"ec.gob.sri.dimm.data", (Exception)e);
                    DataCatalogos.cerrarConexion(con);
                    if (!((ban || estadoCatGener && estadoUbicGeograf && estadoPaises) && estadoRetencionDiv)) {
                        PluginLogger.logError((String)String.format("No se inicializo la data de catalogos. EstadoCatGener: %s, EstadoUbicGeograf: %s, EstadoPaises: %s, EstadoRetencionDiv %s, EstadoParaisosFiscales %s,EstadoPaisesSinParaiso: %s", estadoCatGener, estadoUbicGeograf, estadoPaises, estadoRetencionDiv, estadoParaisosFiscales, estadoPaisesSinParaiso, estadoFiguraJuridica), (String)"ec.gob.sri.dimm.data");
                    }
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DataCatalogos.cerrarConexion(con);
                if (!((ban || estadoCatGener && estadoUbicGeograf && estadoPaises) && estadoRetencionDiv)) {
                    PluginLogger.logError((String)String.format("No se inicializo la data de catalogos. EstadoCatGener: %s, EstadoUbicGeograf: %s, EstadoPaises: %s, EstadoRetencionDiv %s, EstadoParaisosFiscales %s,EstadoPaisesSinParaiso: %s", estadoCatGener, estadoUbicGeograf, estadoPaises, estadoRetencionDiv, estadoParaisosFiscales, estadoPaisesSinParaiso, estadoFiguraJuridica), (String)"ec.gob.sri.dimm.data");
                }
                throw throwable;
            }
            DataCatalogos.cerrarConexion(con);
            if (!((ban || estadoCatGener && estadoUbicGeograf && estadoPaises) && estadoRetencionDiv)) {
                PluginLogger.logError((String)String.format("No se inicializo la data de catalogos. EstadoCatGener: %s, EstadoUbicGeograf: %s, EstadoPaises: %s, EstadoRetencionDiv %s, EstadoParaisosFiscales %s,EstadoPaisesSinParaiso: %s", estadoCatGener, estadoUbicGeograf, estadoPaises, estadoRetencionDiv, estadoParaisosFiscales, estadoPaisesSinParaiso, estadoFiguraJuridica), (String)"ec.gob.sri.dimm.data");
            }
        }
    }

    public Map<String, String> obtenerFiguraJuridcaPorCodigoPais(String codigoPais) throws SQLException {
        TreeMap<String, String> respuesta = new TreeMap<String, String>();
        ConexionBD cbdd = new ConexionBD();
        List listaFiguraJuridica = acFiguraJuridica.obtenerListaFiguraJuridicaPorPais(cbdd.obtenerConexion(), Integer.valueOf(codigoPais).intValue());
        for (RigFiguraJuridica figuraJuridica : listaFiguraJuridica) {
            respuesta.put(String.valueOf(figuraJuridica.getIdentificadorFiguraJuridica()), figuraJuridica.getNombreFiguraJuridica());
        }
        return respuesta;
    }

    public Map<String, String> obtenerPaises() {
        TreeMap<String, String> respuesta = new TreeMap<String, String>();
        List paises = acp.getListaPaises();
        for (AdmPais admPais : paises) {
            respuesta.put(admPais.getCodigo(), admPais.getDescripcion());
        }
        return respuesta;
    }

    public Map<String, String> obtenerPaisRelacionadoParaisoFiscal(String codigoParaiso) throws SQLException {
        TreeMap<String, String> respuesta = new TreeMap<String, String>();
        ConexionBD cbdd = new ConexionBD();
        AdmPais admPais = acp.getPaisRelacionadoParaisoFiscal(cbdd.obtenerConexion(), codigoParaiso);
        respuesta.put(admPais.getCodigo(), admPais.getDescripcion());
        return respuesta;
    }

    public Map<String, String> obtenerPaisesSinParaisoFiscal() {
        TreeMap<String, String> respuesta = new TreeMap<String, String>();
        List paises = acPaisesSinParaisos.getLista();
        for (PaisSinParaiso pais : paises) {
            respuesta.put(pais.getCodigo(), pais.getDescripcion());
        }
        return respuesta;
    }

    public Map<String, String> obtenerParaisosFiscales() {
        LocalDate fechaDeclaracion = LocalDate.now();
        TreeMap<String, String> respuesta = new TreeMap<String, String>();
        Map paraisos = acParaisosFiscales.obtenerParaisosFiscalesPorFechaDeclaracion(fechaDeclaracion);
        for (Map.Entry paraiso : paraisos.entrySet()) {
            respuesta.put(String.valueOf(paraiso.getKey()), ((ParaisoFiscal)paraiso.getValue()).getNombreParaisoFiscal());
        }
        return respuesta;
    }

    public Map<String, String> obtenerParroquiasPorCanton(String codigoCanton) {
        TreeMap<String, String> respuesta = new TreeMap<String, String>();
        List parroquias = acu.getParroquiasPorCanton(codigoCanton);
        for (AdmUbicacionesGeograficas admUbicacionesGeograficas : parroquias) {
            respuesta.put(admUbicacionesGeograficas.getCodigo(), admUbicacionesGeograficas.getDescripcion());
        }
        return respuesta;
    }

    public Map<String, String> obtenerCantonesPorProvincia(String codigoProvincia) {
        TreeMap<String, String> respuesta = new TreeMap<String, String>();
        List cantones = acu.getCantonesPorProvincia(codigoProvincia);
        for (AdmUbicacionesGeograficas admUbicacionesGeograficas : cantones) {
            respuesta.put(admUbicacionesGeograficas.getCodigo(), admUbicacionesGeograficas.getDescripcion());
        }
        return respuesta;
    }

    public Map<String, String> obtenerProvincias() {
        TreeMap<String, String> respuesta = new TreeMap<String, String>();
        List provincias = acu.getProvincias();
        for (AdmUbicacionesGeograficas admUbicacionesGeograficas : provincias) {
            respuesta.put(admUbicacionesGeograficas.getCodigo(), admUbicacionesGeograficas.getDescripcion());
        }
        return respuesta;
    }

    public Map<String, String> obtenerValoresCatalogos(String nemonico) {
        TreeMap<String, String> respuesta = new TreeMap<String, String>();
        Map mapaData = ac.getValoresCatalogo(nemonico);
        for (Map.Entry e : mapaData.entrySet()) {
            respuesta.put((String)e.getKey(), ((RigDetalleCatalogo)e.getValue()).getNombreDetalleCatalogo());
        }
        return respuesta;
    }

    public RigDetalleCatalogo obtenerValor(String nemonicoCatalogo, String codigo) {
        return ac.getValor(nemonicoCatalogo, codigo);
    }

    public static String obtenerNombreDetalleCatalogo(String nemonicoCatalogo, String valorElemento) {
        RigDetalleCatalogo valor = ac.getValor(nemonicoCatalogo, valorElemento);
        return valor == null ? "" : valor.getNombreDetalleCatalogo();
    }

    public static Map<String, RigDetalleCatalogo> obtenerValoresCatalogo(String nemonicoCatalogo) {
        return ac.getValoresCatalogo(nemonicoCatalogo);
    }

    public BigDecimal obtenerTarifaIR(int periodo, String nemonico) {
        BigDecimal bd;
        String resultado;
        block6: {
            ConexionBD cbdd = new ConexionBD();
            Connection con = cbdd.obtenerConexion();
            PreparedStatement ps = null;
            ResultSet rs = null;
            resultado = "";
            bd = BigDecimal.ZERO;
            String aux1 = String.valueOf(periodo - 1) + "-12-30";
            String aux2 = String.valueOf(periodo) + "-01-30";
            String sql = "select dt.valor_catalogo from rig_detalle_catalogo dt join rig_catalogo_tipo ct on ct.codigo_catalogo_tipo = dt.codigo_catalogo_tipo where ct.nemonico = ? and convert(dt.fecha_incio, DATE) between convert('" + aux1 + "', DATE) and convert('" + aux2 + "',DATE)";
            try {
                try {
                    ps = con.prepareStatement(sql);
                    ps.setString(1, nemonico);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        resultado = rs.getString("VALOR_CATALOGO");
                    }
                }
                catch (SQLException e) {
                    PluginLogger.logError((String)"Error al obtener tarifa IR.", (String)"ec.gob.sri.dimm.data", (Exception)e);
                    DataCatalogos.cerrarResultSet(rs);
                    DataCatalogos.cerrarStatement(ps);
                    DataCatalogos.cerrarConexion(con);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DataCatalogos.cerrarResultSet(rs);
                DataCatalogos.cerrarStatement(ps);
                DataCatalogos.cerrarConexion(con);
                throw throwable;
            }
            DataCatalogos.cerrarResultSet(rs);
            DataCatalogos.cerrarStatement(ps);
            DataCatalogos.cerrarConexion(con);
        }
        bd = resultado == null || resultado.trim().isEmpty() ? BigDecimal.ZERO : new BigDecimal(resultado);
        return bd;
    }

    public BigDecimal obtenerTarifaISD(int periodo, int mes, String nemonico) {
        BigDecimal bd;
        String resultado;
        block6: {
            ConexionBD cbdd = new ConexionBD();
            Connection con = cbdd.obtenerConexion();
            PreparedStatement ps = null;
            ResultSet rs = null;
            resultado = "";
            bd = BigDecimal.ZERO;
            String tmp1 = String.valueOf(periodo - 1) + "-01-01";
            String tmp2 = String.valueOf(periodo) + "-" + mes + "-" + this.obtenerNumeroDiasMes(mes);
            String sql = "select dt.valor_catalogo from rig_detalle_catalogo dt join rig_catalogo_tipo ct on ct.codigo_catalogo_tipo = dt.codigo_catalogo_tipo where ct.nemonico = ? and convert(dt.fecha_incio, DATE) between convert('" + tmp1 + "', DATE) " + "and convert('" + tmp2 + "', DATE) " + "order by dt.fecha_incio desc";
            try {
                try {
                    ps = con.prepareStatement(sql);
                    ps.setString(1, nemonico);
                    rs = ps.executeQuery();
                    boolean estado = false;
                    while (rs.next()) {
                        if (estado) continue;
                        estado = true;
                        resultado = rs.getString("VALOR_CATALOGO");
                    }
                }
                catch (SQLException e) {
                    PluginLogger.logError((String)"Error al obtener tarifa ISD", (String)"ec.gob.sri.dimm.data", (Exception)e);
                    DataCatalogos.cerrarResultSet(rs);
                    DataCatalogos.cerrarStatement(ps);
                    DataCatalogos.cerrarConexion(con);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DataCatalogos.cerrarResultSet(rs);
                DataCatalogos.cerrarStatement(ps);
                DataCatalogos.cerrarConexion(con);
                throw throwable;
            }
            DataCatalogos.cerrarResultSet(rs);
            DataCatalogos.cerrarStatement(ps);
            DataCatalogos.cerrarConexion(con);
        }
        bd = resultado == null || resultado.trim().isEmpty() ? BigDecimal.ZERO : new BigDecimal(resultado);
        return bd;
    }

    private String obtenerNumeroDiasMes(int mes) {
        String respuesta = "30";
        if (mes == 2) {
            respuesta = "28";
        }
        return respuesta;
    }

    private static void cerrarConexion(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e) {
                PluginLogger.logError((String)"Error inesperado al cerrar un Connection activo.", (String)"ec.gob.sri.dimm.data", (Exception)e);
            }
        }
    }

    private static void cerrarStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                PluginLogger.logError((String)"Error inesperado al cerrar un PreparedStatement.", (String)"ec.gob.sri.dimm.data", (Exception)e);
            }
        }
    }

    private static void cerrarResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                PluginLogger.logError((String)"Error inesperado al cerrar un ResultSet.", (String)"ec.gob.sri.dimm.data", (Exception)e);
            }
        }
    }

    public Map<String, BigDecimal> obtenerRetencionDividendosPorBaseImponible(BigDecimal baseImponible, Date fechaRegistroComprobante) {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        GregorianCalendar registroComprobante = new GregorianCalendar();
        String fechaRegistro = df.format(fechaRegistroComprobante);
        try {
            registroComprobante.setTime(df.parse(fechaRegistro));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        for (ItemRetencionDividendos retencionDividendos : acr.getLista()) {
            if (baseImponible.compareTo(retencionDividendos.getFraccionBasica()) < 0 || baseImponible.compareTo(retencionDividendos.getExcesoHasta()) > 0 || retencionDividendos.getFechaDesde().compareTo(registroComprobante) > 0 || retencionDividendos.getFechaHasta() != null && retencionDividendos.getFechaHasta().compareTo(registroComprobante) < 0) continue;
            Hashtable<String, BigDecimal> itemRetencionDividendos = new Hashtable<String, BigDecimal>();
            itemRetencionDividendos.put(FRACCION_BASICA, retencionDividendos.getFraccionBasica());
            itemRetencionDividendos.put(EXCESO_HASTA, retencionDividendos.getExcesoHasta());
            itemRetencionDividendos.put(RETENCION_SOBRE_FRACCION, retencionDividendos.getRetencionSobreFraccionBasica());
            itemRetencionDividendos.put(PORCENTAJE_DE_RETENCION, retencionDividendos.getPorcentajeDeRetencion());
            return itemRetencionDividendos;
        }
        return null;
    }

    public Map<String, String> TipoSociedadPorTipoDeclaracion(String mnemonico, String codigoTipoDeclaracion) {
        TreeMap<String, String> respuesta = new TreeMap<String, String>();
        Map mapaData = ac.getValoresCatalogo(mnemonico);
        for (Map.Entry e : mapaData.entrySet()) {
            if (codigoTipoDeclaracion.equals("01")) {
                if (!((String)e.getKey()).equals("01") && !((String)e.getKey()).equals("02") && !((String)e.getKey()).equals("03") && !((String)e.getKey()).equals("04") && !((String)e.getKey()).equals("05") && !((String)e.getKey()).equals("06") && !((String)e.getKey()).equals("07")) continue;
                respuesta.put((String)e.getKey(), ((RigDetalleCatalogo)e.getValue()).getNombreDetalleCatalogo());
                continue;
            }
            if (!((String)e.getKey()).equals("08") && !((String)e.getKey()).equals("09") && !((String)e.getKey()).equals("10")) continue;
            respuesta.put((String)e.getKey(), ((RigDetalleCatalogo)e.getValue()).getNombreDetalleCatalogo());
        }
        return respuesta;
    }
}

